package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.entities.enums.CaseDefinition;
import org.msh.tb.entities.enums.InfectionSite;
import org.msh.tb.entities.enums.PatientType;

/**
 * Stores meta data about etbmanager indicator and also DHIS2 data set
 */
public enum TB11Block3Row {
    PULMONARY_NEW_UNKNOWN_BAC("manag.tbform11.block3.row1", "qTgAlE1JGfC", "goe7bIzQtXx"),
    PULMONARY_NEW_UNKNOWN_CLI("manag.tbform11.block3.row2", "w1EHoTNO9LQ", "J8b1M4jwApw"),
    EXTRAPULMONARY_NEW_UNKNOWN("manag.tbform11.block3.row3", "fCG43ynXiBX", "rh1FSdEqNuw"),
    PREV_TREATED("manag.tbform11.block3.row4", "iyhY5XtD57b", "M0uKAaOLCDy"),
    TOTAL("global.total", null, null);

    String key;
    String testedDataElementId;
    String positiveDataElementId;

    TB11Block3Row(String key, String testedDataElementId, String positiveDataElementId) {
        this.key = key;
        this.testedDataElementId = testedDataElementId;
        this.positiveDataElementId = positiveDataElementId;
    }

    public static TB11Block3Row getRow(InfectionSite infectionSite, PatientType patientType, CaseDefinition caseDefinition) {
        if (patientType.equals(PatientType.PREVIOUSLY_TREATED)){
            return TB11Block3Row.PREV_TREATED;
        }

        // at this point patientType must be New or unknown
        if (infectionSite.equals(InfectionSite.EXTRAPULMONARY)) {
            return TB11Block3Row.EXTRAPULMONARY_NEW_UNKNOWN;
        }

        // at this point infectionSite must be Pulmonary
        if (caseDefinition.equals(CaseDefinition.BACTERIOLOGICALLY_CONFIRMED)) {
            return TB11Block3Row.PULMONARY_NEW_UNKNOWN_BAC;
        } else if (caseDefinition.equals(CaseDefinition.CLINICALLY_DIAGNOSED)) {
            return TB11Block3Row.PULMONARY_NEW_UNKNOWN_CLI;
        }

        throw new RuntimeException("TBForm11Block3Home: Row not found");
    }

    public String getKey(){
        return key;
    }

    public String getTestedDataElementId() {
        return testedDataElementId;
    }

    public String getPositiveDataElementId() {
        return positiveDataElementId;
    }
}
